from flask import Flask, request, send_file, render_template_string
from werkzeug.utils import secure_filename
import os
import io
import zipfile
import pyzipper

app = Flask(__name__, static_folder='css', static_url_path='/css')

# Fungsi Caesar Cipher

def caesar_cipher(text, shift):
    result = ""
    for char in text:
        if char.isalpha():
            start = ord('A') if char.isupper() else ord('a')
            result += chr((ord(char) - start + shift) % 26 + start)
        else:
            result += char
    return result

def layered_encrypt(password, key1, key2):
    first_layer = caesar_cipher(password, int(key1))
    second_layer = caesar_cipher(first_layer, int(key2))
    return second_layer

# Endpoint untuk halaman utama (opsional, jika ingin serve HTML dari Flask)
@app.route('/')
def index():
    # Baca file index.html dari folder html
    with open(os.path.join(os.path.dirname(__file__), 'html', 'index.html'), encoding='utf-8') as f:
        html_content = f.read()
    return html_content

@app.route('/encrypt', methods=['POST'])
def encrypt_file():
    uploaded_file = request.files['file']
    password = request.form['password']
    key1 = request.form['key1']
    key2 = request.form['key2']

    # Proses enkripsi password berlapis
    layered_password = layered_encrypt(password, key1, key2)

    # Simulasi "mengunci" file: tambahkan password hasil enkripsi di awal file
    file_bytes = uploaded_file.read()
    encrypted_content = layered_password.encode() + b'\n' + file_bytes

    # Buat file zip terenkripsi dengan password (pakai pyzipper)
    zip_buffer = io.BytesIO()
    with pyzipper.AESZipFile(zip_buffer, 'w', compression=pyzipper.ZIP_DEFLATED, encryption=pyzipper.WZ_AES) as zip_file:
        zip_file.setpassword(layered_password.encode())
        zip_file.writestr(f"encrypted_{secure_filename(uploaded_file.filename)}", encrypted_content)
    zip_buffer.seek(0)
    zip_filename = f"encrypted_{os.path.splitext(secure_filename(uploaded_file.filename))[0]}.zip"
    return send_file(zip_buffer, as_attachment=True, download_name=zip_filename, mimetype='application/zip')

@app.route('/decrypt', methods=['POST'])
def decrypt_file():
    uploaded_file = request.files['file']
    password = request.form['password']
    key1 = request.form['key1']
    key2 = request.form['key2']

    layered_password = layered_encrypt(password, key1, key2)
    zip_buffer = io.BytesIO(uploaded_file.read())
    try:
        import pyzipper
        with pyzipper.AESZipFile(zip_buffer, 'r') as zip_file:
            zip_file.setpassword(layered_password.encode())
            # Ambil nama file terenkripsi di dalam zip
            namelist = zip_file.namelist()
            if not namelist:
                return render_template_string('<h2 style="color:#d90429;text-align:center;">File zip tidak valid.<br><a href="/">Kembali</a></h2>')
            enc_filename = namelist[0]
            encrypted_content = zip_file.read(enc_filename)
    except RuntimeError:
        return render_template_string('<h2 style="color:#d90429;text-align:center;">Password atau Kunci anda salah<br><a href="/">Kembali</a></h2>')
    except Exception:
        return render_template_string('<h2 style="color:#d90429;text-align:center;">File tidak valid atau tidak terenkripsi dengan sistem ini.<br><a href="/">Kembali</a></h2>')
    try:
        first_line, rest = encrypted_content.split(b'\n', 1)
    except ValueError:
        return render_template_string('<h2 style="color:#d90429;text-align:center;">File tidak valid atau tidak terenkripsi dengan sistem ini.<br><a href="/">Kembali</a></h2>')
    if first_line.decode() != layered_password:
        return render_template_string('<h2 style="color:#d90429;text-align:center;">Password atau Kunci anda salah<br><a href="/">Kembali</a></h2>')
    output = io.BytesIO()
    output.write(rest)
    output.seek(0)
    # Nama file asli tanpa "encrypted_"
    if enc_filename.startswith("encrypted_"):
        out_filename = enc_filename[len("encrypted_"):]
    else:
        out_filename = "decrypted_" + enc_filename
    return send_file(output, as_attachment=True, download_name=out_filename)

@app.route('/css/<path:filename>')
def serve_css(filename):
    return send_file(os.path.join('css', filename))

if __name__ == '__main__':
    app.run(debug=True)
